/**
 * 
 */
package com.ejie.ab18a.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.xml.XMLConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ejie.ab18a.combo.Ab18aObjetoWSBean;
import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.properties.Ab18aPropertiesManager;
import com.ejie.xmlbeans.ServicioObtencionPerfilesUsuarios;
import com.ejie.xmlbeans.TipoEntidadImpulsora;
import com.ejie.xmlbeans.TipoEntidadTramitadora;
import com.ejie.xmlbeans.TipoMesa;
import com.ejie.xmlbeans.TipoOperacion;
import com.ejie.xmlbeans.TipoPerfil;
import com.ejie.xmlbeans.TipoPoder;

/**
 * @author XXXX
 * 
 */
public final class Utilidades {

	private static final Logger logger = LoggerFactory.getLogger(Utilidades.class);

	/**
	 * Constructor privado no se llama
	 */
	private Utilidades() {
		// no se llama
	}

	/**
	 * Not null and not empty.
	 * 
	 * @param campo
	 *            the campo
	 * @return true, if successful
	 */
	public static boolean notNullAndNotEmpty(final Object campo) {
		boolean esNoNuloYNoVacio = true;

		if (campo == null) {
			esNoNuloYNoVacio = false;
		} else {
			if (campo instanceof String && ((String) campo).trim().length() == 0) {
				esNoNuloYNoVacio = false;
			}
			if (campo instanceof Long && ((Long) campo) == 0) {
				esNoNuloYNoVacio = false;
			}
			if (campo instanceof List<?> && (((List<?>) campo).size()) == 0) {
				esNoNuloYNoVacio = false;
			}
		}
		return esNoNuloYNoVacio;
	}

	/**
	 * Not null and not zero.
	 * 
	 * @param campo
	 *            the campo
	 * @return true, if successful
	 */
	public static boolean notNullAndNotZero(final Number campo) {
		boolean esNoNuloYNoZero = true;

		if (campo == null || campo.doubleValue() == 0) {
			esNoNuloYNoZero = false;
		}
		return esNoNuloYNoZero;
	}

	/**
	 * Check if null or empty.
	 * 
	 * @param campo
	 *            the campo
	 * @return true, if successful
	 */
	public static boolean nullOrEmpty(final Object campo) {
		return !notNullAndNotEmpty(campo);
	}

	public static boolean nullOrZero(final Number campo) {
		return !notNullAndNotZero(campo);
	}

	public static boolean validarContraXSD(InputStream in, String xsd) {
		try {
			SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			File fichero = new File(xsd);
			boolean isFile = fichero.isFile();
			if (isFile) {
				Schema schema = factory.newSchema(new File(xsd));
				Validator validator = schema.newValidator();
				Reader reader = new InputStreamReader(in, "UTF-8");
				validator.validate(new StreamSource(reader));

				return true;
			} else {
				return false;
			}

		} catch (Exception ex) {
			return false;
		}
	}

	public static Date convertirXMLGregorianToDate(XMLGregorianCalendar xmlCal) {
		Date date = xmlCal.toGregorianCalendar().getTime();
		return date;
	}

	/**
	 * Gets the string from document.
	 * 
	 * @param doc
	 *            the doc
	 * @return the string from document
	 */
	public static String getStringFromDocument(Document doc) {
		try {
			DOMSource domSource = new DOMSource(doc);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			return writer.toString();
		} catch (TransformerException ex) {
			// logger.error("Se ha producido un error en getStringFromDocument...'"
			// + doc + "'", ex);
			return null;
		}
	}

	public static List<String> obtenerDirectorios(String pathFile) {
		File directorioPrincipal = new File(pathFile);
		String[] directorios = directorioPrincipal.list(new FilenameFilter() {
			@Override
			public boolean accept(File current, String name) {
				return new File(current, name).isDirectory();
			}
		});

		return Arrays.asList(directorios);
	}

	public static String UTF8ToAnsi(String ruta) {
		try {
			boolean firstLine = true;
			File fichero = new File("/datos/ab18a/temporal/prueba.xml");
			fichero.getParentFile().mkdirs();

			FileInputStream fis = new FileInputStream(ruta);
			BufferedReader r = new BufferedReader(new InputStreamReader(fis, "UTF8"));
			FileOutputStream fos = new FileOutputStream(fichero);
			Writer w = new BufferedWriter(new OutputStreamWriter(fos, "Cp1252"));
			for (String s = ""; (s = r.readLine()) != null;) {
				if (firstLine) {
					s = removeUTF8BOM(s);
					firstLine = false;
				}
				w.write(s + System.getProperty("line.separator"));
				w.flush();
			}

			w.close();
			r.close();
			FileUtils.copyFile(new File("/datos/ab18a/temporal/prueba.xml"), new File(ruta));
		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return ruta;
	}

	private static String removeUTF8BOM(String s) {
		if (s.startsWith(Constantes.UTF8_BOM)) {
			return s.substring(1);
		}
		return s;
	}

	public static String byteArrayToBase64String(byte[] anuncio) {
		return Base64.encodeBase64String(anuncio);
	}

	/**
	 * Checks if is blank.
	 * 
	 * @param cadena
	 *            the cadena
	 * @return true, if is blank
	 */
	public static boolean isBlank(String cadena) {
		return (cadena == null || "".equals(cadena));
	}

	public static boolean isInteger(String dato) {
		try {
			Integer.parseInt(dato);
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	/**
	 * String2 document.
	 * 
	 * @param textoXML
	 *            the texto xml
	 * @return the document
	 */
	public static Document string2Document(String textoXML) {

		Document document = null;

		try {

			DocumentBuilderFactory factory = null;
			DocumentBuilder builder = null;

			factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			factory.setIgnoringElementContentWhitespace(false);
			builder = factory.newDocumentBuilder();
			StringReader stringIn = new StringReader(textoXML);
			document = builder.parse(new InputSource(stringIn));

		} catch (ParserConfigurationException pce) {
			Utilidades.logger.error("Se ha producido un error al convertir el String a document: " + pce);

		} catch (IOException io) {
			Utilidades.logger.error("Se ha producido un error al convertir el String a document: " + io);
		} catch (SAXException se) {
			Utilidades.logger.error("Se ha producido un error al convertir el String a document: " + se);
		}

		return document;
	}

	/**
	 * Rellenar usuario.
	 * 
	 * @param usuario
	 *            the usuario
	 * @param perfil
	 *            the perfil
	 */
	public static void rellenarUsuario(Ab18aUsuario usuario, ServicioObtencionPerfilesUsuarios perfil) {
		List<TipoPerfil> tipoPerfil = new ArrayList<TipoPerfil>();
		List<TipoOperacion> operaciones = new ArrayList<TipoOperacion>();
		List<TipoEntidadImpulsora> eImpulsoras = new ArrayList<TipoEntidadImpulsora>();
		List<TipoPoder> poderes = new ArrayList<TipoPoder>();
		List<TipoEntidadTramitadora> eTramitadoras = new ArrayList<TipoEntidadTramitadora>();
		List<TipoMesa> mesas = new ArrayList<TipoMesa>();

		usuario.setNombre(perfil.getNombre());
		usuario.setAmbito(perfil.getAmbito());
		usuario.setOrigen(perfil.getOrigen());
		usuario.setEntidadImplusora(perfil.getVinculaciones().getEntidadImpulsora());
		usuario.setIdUsuario(perfil.getIdUsuario());
		usuario.setIdEnteControl(perfil.getIdEnteControl());

		Iterator<TipoPerfil> iteratorperfil = perfil.getPerfiles().getPerfil().iterator();
		boolean esAuditor = false;
		boolean esTramitador = false;
		boolean esDirector = false;
		boolean esAdministradorRegistro = false;
		boolean esRevisor = false;

		while (iteratorperfil.hasNext()) {
			TipoPerfil perfilaux = iteratorperfil.next();
			tipoPerfil.add(perfilaux);
			if (perfilaux.getCodigoPerfil().equals(Constantes.COD_DIRECTOR_REGISTRO)) {
				esDirector = true;
			} else if (perfilaux.getCodigoPerfil().equals(Constantes.COD_ADMINISTRADOR_REGISTRO)) {
				esAdministradorRegistro = true;
			} else if (perfilaux.getCodigoPerfil().equals(Constantes.COD_TRAMITADOR_REGISTRO)) {
				esTramitador = true;
			} else if (perfilaux.getCodigoPerfil().equals(Constantes.COD_AUDITOR_REGISTRO)) {
				esAuditor = true;
			} else if (perfilaux.getCodigoPerfil().equals(Constantes.COD_REVISOR_REGISTRO)) {
				esRevisor = true;
			}

			Iterator<TipoOperacion> iteratoroperaciones = perfilaux.getOperaciones().getOperacion().iterator();
			while (iteratoroperaciones.hasNext()) {
				TipoOperacion operacionaux = iteratoroperaciones.next();
				if (operacionaux.getCodigoOperacion().equalsIgnoreCase(Constantes.COD_OPERACION_18)) {
					usuario.setVisibleMenu(true);
					usuario.setVisibleMenuContratos(true);
					usuario.setVisibleConsolidados(true);
				}
				if (operacionaux.getCodigoOperacion().equalsIgnoreCase(Constantes.COD_OPERACION_19)) {
					usuario.setVisibleMenu(true);
					usuario.setVisibleMenuContratos(true);
					usuario.setVisibleNConsolidados(true);
				}
				operaciones.add(operacionaux);

			}
		}

		establecerPermisosPorPerfil(usuario, esAuditor, esDirector, esTramitador, esRevisor, esAdministradorRegistro);

		Iterator<TipoEntidadImpulsora> iteratorEImpulsoras = perfil.getVinculaciones().getEntidadImpulsora().iterator();
		while (iteratorEImpulsoras.hasNext()) {
			eImpulsoras.add(iteratorEImpulsoras.next());
		}

		Iterator<TipoPoder> iteratorPoderes = perfil.getVinculaciones().getPoder().iterator();
		while (iteratorPoderes.hasNext()) {
			poderes.add(iteratorPoderes.next());
		}

		Iterator<TipoEntidadTramitadora> iteratorETramitadoras = perfil.getVinculaciones().getEntidadTramitadora().iterator();
		while (iteratorETramitadoras.hasNext()) {
			eTramitadoras.add(iteratorETramitadoras.next());
		}

		Iterator<TipoMesa> iteratorMesas = perfil.getVinculaciones().getMesa().iterator();
		while (iteratorMesas.hasNext()) {
			mesas.add(iteratorMesas.next());
		}

		usuario.setPoderes(poderes);
		usuario.setMesas(mesas);
		usuario.setEntidadesImpulsoras(eImpulsoras);
		usuario.setEntidadesTramitadoras(eTramitadoras);
		usuario.setOperaciones(operaciones);
		usuario.setPerfiles(tipoPerfil);
	}

	private static void establecerPermisosPorPerfil(Ab18aUsuario usuario, boolean esAuditor, boolean esDirector, boolean esTramitador,
			boolean esRevisor, boolean esAdministradorRegistro) {

		if (esTramitador && !esAdministradorRegistro) {
			usuario.setVisibleIncoherencias(true);
		}
		if (esAdministradorRegistro) {
			Utilidades.rellenarVisibleGeneracionInformes(usuario);
			usuario.setVisibleAdministracion(true);
			return;
		}
		usuario.setVisibleAdministracion(false);
		if (esDirector || esAuditor) {
			Utilidades.rellenarVisibleGeneracionInformes(usuario);
		}

		if ((esDirector || esRevisor) && !esTramitador) {
			usuario.setConsulta(true);
		}
		if (esAuditor) {
			usuario.setVisibleMenu(true);
		}

	}

	/**
	 * Rellenar visible generacion informes.
	 * 
	 * @param usuario
	 *            the usuario
	 */
	private static void rellenarVisibleGeneracionInformes(Ab18aUsuario usuario) {
		usuario.setVisibleGeneracionInformes(true);
		usuario.setVisibleEnvios(true);
		usuario.setVisibleInformes(true);
	}

	/**
	 * Rellenar usuario local.
	 * 
	 * @param usuario
	 *            the usuario
	 * @param perfil
	 *            the perfil
	 * @param nombre
	 *            the nombre
	 */
	public static void rellenarUsuarioLocal(Ab18aUsuario usuario, ServicioObtencionPerfilesUsuarios perfil, String nombre) {
		usuario.setNombre(nombre);
		usuario.setAmbito(Integer.valueOf(Ab18aPropertiesManager.getProperty(Constantes.USUARIO_AMBITO)));
		usuario.setIdUsuario(Integer.valueOf(Ab18aPropertiesManager.getProperty(Constantes.USUARIO_ORIGEN)));
		usuario.setDni(Ab18aPropertiesManager.getProperty(Constantes.PROP_DNI_USUARIO));
		List<TipoOperacion> operaciones = new ArrayList<TipoOperacion>();
		TipoOperacion operacionaux = new TipoOperacion();
		operacionaux.setCodigoOperacion(Constantes.COD_OPERACION_19);
		operaciones.add(operacionaux);
		operacionaux = new TipoOperacion();
		operacionaux.setCodigoOperacion(Constantes.COD_OPERACION_18);
		operaciones.add(operacionaux);
		usuario.setVisibleMenu(true);
		usuario.setVisibleAdministracion(true);
		usuario.setVisibleMenuContratos(true);
		usuario.setVisibleNConsolidados(true);
		usuario.setVisibleConsolidados(true);
		usuario.setVisibleGeneracionInformes(true);
		usuario.setVisibleEnvios(true);
		usuario.setVisibleInformes(true);
		usuario.setVisibleIncoherencias(true);
	}

	/**
	 * calculoLetraDNI
	 * 
	 * @param dniUsuarioLogueado
	 *            String
	 * @return String
	 */
	public static String calculoLetraDNI(String dniUsuarioLogueado) {
		if (dniUsuarioLogueado != null) {
			if (dniUsuarioLogueado.length() == 8) {
				dniUsuarioLogueado = dniUsuarioLogueado + Utilidades.letraDniNie(dniUsuarioLogueado);
			} else if (dniUsuarioLogueado.length() < 8) {
				for (int i = dniUsuarioLogueado.length(); i < 8; i++) {
					dniUsuarioLogueado = "0" + dniUsuarioLogueado;
				}
				dniUsuarioLogueado = dniUsuarioLogueado + Utilidades.letraDniNie(dniUsuarioLogueado);
			}
		} else {
			dniUsuarioLogueado = "0";
		}
		return dniUsuarioLogueado;

	}

	/**
	 * Letra dni nie.
	 * 
	 * @param nif
	 *            the nif
	 * @return the char
	 * @throws NumberFormatException
	 *             the number format exception
	 */
	public static String letraDniNie(String nif) throws NumberFormatException {
		String letra = "";
		try {
			String strCadenaCalculoLetra = "TRWAGMYFPDXBNJZSQVHLCKE";
			if (nif.substring(0, 1).equals("X")) {
				nif = "0" + nif.substring(1, 8);
			} else if (nif.substring(0, 1).equals("Y")) {
				nif = "1" + nif.substring(1, 8);
			} else if (nif.substring(0, 1).equals("Z")) {
				nif = "2" + nif.substring(1, 8);
			}
			letra = String.valueOf(strCadenaCalculoLetra.charAt(Integer.parseInt(nif) % 23));
			return letra;
		} catch (NumberFormatException e) {
			return "";
		}
	}

	/**
	 * Gets the idioma actual.
	 * 
	 * @return the idioma actual
	 */
	public static String getIdiomaActual() {

		Locale locale = LocaleContextHolder.getLocale();

		return locale.getLanguage();
	}

	/**
	 * Obtener lista poderes.
	 * 
	 * @param dniUsuario
	 *            the dni usuario
	 * @param ambito
	 *            the ambito
	 * @param enRevascon
	 *            the en revascon
	 * @param idioma
	 *            the idioma
	 * @return the list
	 */
	public static List<Ab18aObjetoWSBean> obtenerListaPoderes(String dniUsuario, String ambito, String enRevascon, String idioma) {

		String[] params = { "usuario", "ambito", "enRevascon", "idioma" };
		String[] values = { dniUsuario, ambito, enRevascon, idioma };

		Document doc = null;
		try {
			String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerPoderesAdjudicadoresOSBUS", params, values);

			doc = Utilidades.string2Document(resultado);
		} catch (Exception e) {
			Utilidades.logger.error("Se ha producido un error en el obtenerListaPoderes:", e);
		}

		return Utilidades.obtenerValorXML(doc);
	}

	/**
	 * Obtener valor xml.
	 * 
	 * @param doc
	 *            the doc
	 * @return the list
	 */
	public static List<Ab18aObjetoWSBean> obtenerValorXML(Document doc) {

		List<Ab18aObjetoWSBean> listaPoder = new ArrayList<Ab18aObjetoWSBean>();
		try {
			if (doc != null && doc.getElementsByTagName("elemento") != null && doc.getElementsByTagName("elemento").getLength() > 0) {
				// *********************************
				// *********************************
				// Obtenemos la etiqueta raiz
				Element elementRaiz = doc.getDocumentElement();
				// Iteramos sobre sus hijos
				NodeList hijos = elementRaiz.getChildNodes();
				for (int i = 0; i < hijos.getLength(); i++) {
					Node nodo = hijos.item(i);
					NodeList datos = nodo.getChildNodes();
					Ab18aObjetoWSBean objetoWS = Utilidades.crearAb18aObjetoWSBean();
					boolean encontrado = false;
					for (int z = 0; z < datos.getLength(); z++) {
						Node nodoHijos = datos.item(z);
						if (nodoHijos instanceof Element) {
							if (nodoHijos != null && nodoHijos.getNodeName().equalsIgnoreCase("id")) {
								objetoWS.setId(Long.valueOf(nodoHijos.getTextContent()));
								encontrado = true;
							} else if (nodoHijos != null && nodoHijos.getNodeName().equalsIgnoreCase("descripcion")) {
								objetoWS.setDescripcion(nodoHijos.getTextContent());
								encontrado = true;
							}
						}
					}
					if (encontrado) {
						listaPoder.add(objetoWS);
					}
				}
			}
		} catch (Exception e) {
			Utilidades.logger.error("Se ha producido un error en obtenerValorXML:" + e);
		}
		return listaPoder;
	}

	/**
	 * Crear ab18a objeto ws bean.
	 * 
	 * @return the ab18a objeto ws bean
	 */
	private static Ab18aObjetoWSBean crearAb18aObjetoWSBean() {
		return new Ab18aObjetoWSBean();
	}

	public static String filtroLikeCaracterEspecial(String filtroLike) {

		String barra = "\\";
		int currentIndex = -1;

		if (filtroLike.contains("%")) {
			StringBuffer filtroLikeModificado = new StringBuffer(filtroLike);

			while (filtroLikeModificado.lastIndexOf("%") > currentIndex) {
				if (filtroLikeModificado.lastIndexOf("%") == 0) {
					filtroLikeModificado.insert(0, barra);
					currentIndex = 1;
				} else {
					if (filtroLikeModificado.charAt(filtroLikeModificado.lastIndexOf("%")) != '\\') {
						filtroLikeModificado.insert(filtroLikeModificado.lastIndexOf("%"), barra);
						currentIndex = filtroLikeModificado.lastIndexOf("%");
					}
				}
			}

			return filtroLikeModificado.toString();
		} else {
			return filtroLike;
		}
	}
}
